/*
	Stempora Web Framework
	Copyright (c) 2002-2018 Stempora. 
	All rights reserved.
		web:  www.stempora.com
		mail: support@stempora.com				
*/

var STBModuleCTA = Object.create(STBModule.prototype);

STBModuleCTA.name = "ModuleCTA";
STBModuleCTA.initPaddings = function () {

	var cta = jQuery('.widget-cta:not(.__done)').find('.cta-btn');

	if (cta.length > 0) {
		cta.each(function () {

			var buttonWidth = jQuery(this).outerWidth();

			if (jQuery("html").attr("dir") == "rtl") {
				jQuery(this).siblings().css('padding-left', buttonWidth + 20);
			} else {
				jQuery(this).siblings().css('padding-right', buttonWidth + 20);
			}

			jQuery(this).addClass("__done");
		});
	}
}

STBModuleCTA.resetPaddings = function() {
	jQuery('.widget-cta').removeClass("__done");
}

STBModuleCTA.runOnReady = function() {
	STBModuleCTA.initPaddings();
}

STBModuleCTA.runOnContentUpdate = function() {
	STBModuleCTA.initPaddings();
}

STBModuleCTA.runOnResize = function() {
	STBModuleCTA.resetPaddings();
	STBModuleCTA.initPaddings();
}

site.registerModule(STBModuleCTA);